library IEEE;
use IEEE.std_logic_1164.all;
use std.textio.all;
use ieee.std_logic_textio.all;
use IEEE.numeric_std.all;


entity COUNTER_TB is
end COUNTER_TB;

architecture COUNTER_TB_arch of COUNTER_TB is

component COUNTER is
    port (
        RESET: in STD_LOGIC;
        INCR: in STD_LOGIC;
        COUNT: out STD_LOGIC_VECTOR (2 downto 0)
    );
end component COUNTER;

signal reset, incr : std_logic := '0';
signal count : std_logic_vector (2 downto 0);

constant wait_time : time := 5 ns;
constant sim_time : time := 80 ns;
constant test_time : integer := 7;

begin

    COUNTER1: COUNTER
    	port map (reset, incr, count);
-------------------------------------------------------------------------------
-- main testing process
-------------------------------------------------------------------------------
    TestProcess: process
        variable lout : line;
        variable i:integer := 0;
        variable reset_tested: boolean := false;
	begin
		wait for wait_time;
		reset <= '1';
		wait for wait_time;
		assert (count = "000") report "Reset Failed";
--		write(lout, count);
--		writeline(output, lout);
		reset <= '0';
		wait for wait_time;
		while i < 8 loop
			assert (count = std_logic_vector(to_unsigned(i, 3)))
                        report "Counter incorrect";
			i:= i+1;
			wait for wait_time;
			incr <= '1';
			wait for wait_time;
			incr <= '0';
			if ((not reset_tested) and i = test_time) then
				reset_tested := true;
				reset <= '1';
				wait for wait_time;
				reset <= '0';
				i := 0;
                                assert (count = std_logic_vector(to_unsigned(i, 3)))
                                report "Reset in count failed";
			end if;
		end loop;
		wait;
    end process;
  
end COUNTER_TB_arch;



