library IEEE;
use IEEE.std_logic_1164.all;
use ieee.std_logic_textio.all;
use IEEE.numeric_std.all;

library std;
use std.textio.all;


entity Encrypter_tb is
end Encrypter_tb;

architecture Enc_tb_arch of Encrypter_tb is

    component Encrypter is
	port(
	  count : in std_logic_vector(2 downto 0);
	  hex : in std_logic_vector(3 downto 0);
	  data: out std_logic_vector(7 downto 0)
	);
    end component Encrypter;
    
    component Decrypter is
    port(
      count : in std_logic_vector(2 downto 0);
      hex : out std_logic_vector(3 downto 0);
      data: in std_logic_vector(7 downto 0)
    );
    end component Decrypter;
    
    component COUNTER is
    port (
        reset: in STD_LOGIC;
        incr: in STD_LOGIC;
        COUNT: out STD_LOGIC_VECTOR (2 downto 0)
    );
    end component COUNTER;

    signal clk : std_logic := '0';

    signal count_sig : std_logic_vector(2 downto 0);
    signal hex_to_encr, hex_decr: std_logic_vector(3 downto 0);
    signal data: std_logic_vector(7 downto 0);
    signal reset, incr: std_logic := '0';
    shared variable done, done_file_i, done_file_o: boolean := false;
    shared variable dig_in : std_logic_vector(3 downto 0);
    signal failed_e, failed_d : integer := 0;
    signal reset_yet: boolean:= false;
    
    constant clk_period : time := 5 ns;
    constant sim_time : time := 100 ns;

begin

    dut1: Encrypter
        port map (count_sig, hex_to_encr, data);
    dut2: Decrypter
        port map (count_sig, hex_decr, data);
    count_1: Counter
    	port map (reset, incr, count_sig);

-- the clock upon which we synchronize all of our processes
    clk <= not clk after clk_period when not done else '0';
    incr <= clk;
    ---------------------------------------------------------------------------
    -- This process reads the input from the file
    ---------------------------------------------------------------------------
    TestingProcess: process(clk)
        variable l, lout : line;
        file input : text is "inputa.txt";
--    	variable reset_yet : boolean := false;    
         begin
	   if clk'event and clk='1' then
		  if not reset_yet then
		   	reset <= '1';
	 	  	reset_yet <= true;
		  else
		   	reset <= '0';
		   	if not endfile(input) then
			    readline(input, l);
			    hread(l, dig_in);
			    write(lout, string'("At time "));
			    write(lout, now);
			    write(lout, string'(", the input is : "));
			    write(lout, dig_in);
			    writeline(output, lout);
			    hex_to_encr <= dig_in;
			else
			    done_file_i := true;
			end if;
	 	  end if;
	   end if;

--	    if (now < 5 ns) then
--	        reset <= '1';
--	    elsif (now < 25 ns) then
--	    	reset <= '0';
--	    else
--		incr <= clk;
--	    end if;
--	    
--	    if (now > 24 ns) then
--	        if clk'event and clk = '1' then
--		    hex_to_encr <= dig_in;
----		elsif clk'event and clk = '0' then
--		    if not endfile(input) then
--			readline(input, l);
--			hread(l, dig_in);
----			write(lout, string'("At time "));
----			write(lout, now);
----			write(lout, string'(", the input is : "));
----			write(lout, dig_in);
----			writeline(output, lout);
--		    else
--			done := true;
--		    end if;
--		end if;
--	    end if;
         end process;

    ---------------------------------------------------------------------------
    -- The process that will check the expected output agains the actual
    ---------------------------------------------------------------------------        
    VerifyProcess: process(clk)
        variable l, lout : line;
        file output1 : text is "output1a.txt";
        variable dig_expected: std_logic_vector(7 downto 0);
        begin
	    if (now < 6 ns) then
	        null;
	    elsif (now < 11 ns) then
	        assert (count_sig = "000")
                report "Counter does not reset" severity failure;
	    else
	        if clk'event and clk = '0' then
		    if not endfile(output1) then
			readline(output1, l);
			hread(l, dig_expected);
			
                        if not(data = dig_expected) then
                          failed_e <= failed_e + 1;
                          write(lout, string'("At time "));
			  write(lout, now);
			  write(lout, string'(", the output should be : "));
			  write(lout, dig_expected);
			  writeline(output, lout);
                          assert (false)
                          report "Bad output data" severity error;
                        end if;
                        if not (hex_decr = dig_in) then
                          failed_d <= failed_d + 1;
                          assert (false);  
                          report "Bad decryption" severity error;  
                        end if;
                    else
                    	done_file_o := true;
		    end if;
		end if;
	    end if;
        end process;

    ---------------------------------------------------------------------------
    -- This process outputs the results
    ---------------------------------------------------------------------------
    ReportProcess: process(clk)
      variable lout : line;
    begin 
      if clk'event and clk='1' then
	  if done_file_i or done_file_o then
	    write(lout, string'("*** Encryption failed "));
	    write(lout, failed_e);
	    write(lout, string'(" times. ***"));
	    writeline(output, lout);
	    write(lout, string'("*** Decryption failed "));
	    write(lout, failed_d);
	    write(lout, string'(" times. ***"));
	    writeline(output, lout);
	    done := true;
	  end if;
      end if;
 end process;
	
            
end Enc_tb_arch;









