library IEEE;
use IEEE.std_logic_1164.all;
use ieee.std_logic_textio.all;
use IEEE.numeric_std.all;

library std;
use std.textio.all;

entity Lab1tb is
end Lab1tb;

architecture Lab1tb_arch of Lab1tb is
  component Lab1 is
    port (
      AWAY: in STD_LOGIC;
      ARMED: in STD_LOGIC;
      FRONTDOOR: in STD_LOGIC;
      WINDOW: in STD_LOGIC;
      ZONE1: in STD_LOGIC;
      ZONE2: in STD_LOGIC;
      ALARM: out STD_LOGIC
      );
  end component Lab1;
  signal away, armed, frontdoor, window, zone1, zone2: std_logic := '0';
  -- port signals
  signal clk: std_logic := '0';
  signal alarm: std_logic;
  constant clk_period : time := 5 ns;
  signal failed : integer := 0; 	       -- trials failed
  signal done, done_file_i, done_file_o : boolean := false; 
  -- termination signals

begin

  lab1_dut : Lab1
    port map (
      away, armed, frontdoor, window, zone1, zone2, alarm
      );

  
  clk <= not clk after clk_period when not done else '0';

-------------------------------------------------------------------------------
-- TestingProcess:  Supplies input to the design under testing
-------------------------------------------------------------------------------
         TestingProcess: process(clk)
           variable l : line;
           file input : text is "input.txt";
           variable away_in, armed_in, frontdoor_in: std_logic;
           variable window_in, zone1_in, zone2_in : std_logic;
         begin
           if clk'event and clk = '1' then
             if not endfile(input) then
               readline(input, l);
               read(l, away_in);
               read(l, armed_in);
               read(l, frontdoor_in);
               read(l, window_in);
               read(l, zone1_in);
               read(l, zone2_in);
               away <= away_in;
               armed <= armed_in;
               frontdoor <= frontdoor_in;
               window <= window_in;
               zone1 <= zone1_in;
               zone2 <= zone2_in;
             else
               done_file_i <= true;
             end if;
           end if;
         end process;
  
-------------------------------------------------------------------------------
-- VerifyingProcess: confirms output against the expected output
-------------------------------------------------------------------------------
           VerifyingProcess: process(clk)
             variable alarm_out : std_logic;
             variable l, lout : line;
             file output1 : text is "output.txt";
           begin
             if clk'event and clk = '0' then
               if not endfile(output1) then
                 readline(output1, l);
                 read(l, alarm_out);
                 if not(alarm_out = alarm) then
                   failed <= failed + 1;
                   write(lout, string'("At time "));
                   write(lout, now);
                   write(lout, string'(", Alarm should be "));
                   if alarm_out = '1' then
                     write(lout, string'("on."));
                   else
                     write(lout, string'("off."));
                   end if;
                   writeline(output, lout);
                   assert (false)
                     report "Alarm signals do not match";
                 end if;
               else
                 done_file_o <= true;
               end if;
             end if;
           end process;

  ----------------------------------------------------------------
  -- The process that reports findings
  ----------------------------------------------------------------
  ReportingProcess: process(clk)
    variable lout: line;
  begin
    if clk'event and clk='1' then
      if done_file_i or done_file_o then
        write(lout, string'("***-------------------------------***"));
        writeline(output, lout);
        if failed>0 then
          write(lout, string'("***    Circuit failed "));
          write(lout, failed);
          write(lout, string'(" times.   ***"));
          writeline(output, lout);
        else
          write(lout, string'("***   Circuit passed all tests    ***"));
          writeline(output, lout);
        end if;
        write(lout, string'("***-------------------------------***"));
        writeline(output, lout);  
        done <= true;  
      end if;
    end if;
  end process;
end Lab1tb_arch;







